<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

require_once 'libs/core.php';

use WHMCS\Domains\DomainLookup\ResultsList;
use WHMCS\Domains\DomainLookup\SearchResult;
use WHMCS\Module\Registrar\Registrarmodule\ApiClient;
use WHMCS\Database\Capsule;

    function bknsjsc_getConfigArray() {
        $configarray = array(
            "Username" => array(
                "Type" => "text",
                "Size" => "50",
                "Description" => "Enter your username here"
            ),
            "Password" => array(
                "Type" => "password",
                "Size" => "50",
                "Description" => "Enter your password here"
            ),
        );
        return $configarray;
    }

    function _getKey() {
        return 'NDIyNWQwNzk0NjE0NDlkODcwM2UzYjcwZTAxYjIzZDRjRk5Yd2QvMkxyYXNEQWo5Zit6VHJVbWZ5Tll3Z2wxR2p4OGx1YU5mR2c9PQ==';
    }

    function bknsjsc_RegisterDomain($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->Register();
        if (!$result['order_num'] ) {
                return ["error" => $result['error'] ?: "Wrong response from the server while registering domain."];
            } else {
                return [];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_TransferDomain($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->Transfer();
        if (!$result['order_num'] ) {
                return ["error" => $result['error'] ?: "Wrong response from the server while transfering domain."];
            } else {
                return [];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_RenewDomain($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            return ["error" => "This action is not available for this Domain Registrant"];
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_GetEPPCode($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_Sync($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->synchInfo();
        if (empty($result) || !$result['success']) {
                return ["error" => $result['error'] ?: "Wrong response from the server while obtaining domain information."];
            } else {
                return [
                    "active" => ($result['status'] == 'Active' ? true : false),
                    "expirydate" => $result["expires"],
                ];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_GetRegistrarLock($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->getRegistrarLock();
            if (!$result['success']) {
                    return ["error" => $result['error'] ?: "Wrong response from the server while obtaining registrar lock status."];
                } else {
                    return ($result['registrar_lock'] ? 'locked' : 'unlocked');
                }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_SaveRegistrarLock($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->updateRegistrarLock();
        if (!$result['success']) {
                return ["error" => $result['error'] ?: "Wrong response from the server while updating registrar lock."];
            } else {
                return [];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_GetContactDetails($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->getContactInfo();
        if (empty($result) || !$result['success']) {
                return ["error" => $result['error'] ?: "Wrong response from the server while obtaining domain contact information."];
            } else {
                return $result['items'];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_SaveContactDetails($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->updateContactInfo();
        if (!$result['success']) {
                return ["error" => $result['error'] ?: "Wrong response from the server while updating domain contact information."];
            } else {
                return [];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_GetDNS($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->getDNSManagement();
        if (empty($result) || !$result['success']) {
                return ["error" => $result['error'] ?: "Wrong response from the server while obtaing DNS records."];
            } else {
                return $result['items'];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_SaveDNS($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            return ["error" => "This action is not available for this Domain Registrant"];
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_GetNameservers($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->getNameServers();
        if (empty($result) || !$result['success']) {
                return ["error" => $result['error'] ?: "Wrong response from the server while obtaining domain name servers."];
            } else {
                return $result['items'];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_SaveNameservers($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_RegisterNameserver($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->registerNameServer();
        if (!$result['success']) {
                return ["error" => $result['error'] ?: "Wrong response from the server while registering domain name server."];
            } else {
                return [];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_ModifyNameserver($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->modifyNameServer();
        if (!$result['success']) {
                return ["error" => $result['error'] ?: "Wrong response from the server while updating domain name server."];
            } else {
                return [];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_DeleteNameserver($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->deleteNameServer();
        if (!$result['success']) {
                return ["error" => $result['error'] ?: "Wrong response from the server while deleting domain name server."];
            } else {
                return [];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_GetEmailForwarding($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->getEmailForwarding();
        if (empty($result) || !$result['success']) {
                return ["error" => $result['error'] ?: "Wrong response from the server while obtaining domain email forwarding information."];
            } else {
                return $result['items'];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_SaveEmailForwarding($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->updateEmailForwarding();
        if (!$result['success']) {
                return ["error" => $result['error'] ?: "Wrong response from the server while updating domain email forwarding."];
            } else {
                return [];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
    function bknsjsc_IDProtectToggle($params = []) {
        try {
            $domkey = _getKey();
            $core = new CoreHBDomainReseller($params,$domkey);
            $result = $core->updateIDProtection();
        if (!$result['success']) {
                return ["error" => "Wrong response from the server while updating domain ID Protection."];
            } else {
                return [];
            }
        } catch (\Exception $e) {
            return ["error" => $e->getMessage()];
        }
    }
?>